package gov.va.genisis2Test.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import gov.va.genisis2.model.CommentHistory;
import gov.va.genisis2.model.Request;
import gov.va.genisis2.model.RequestHistory;
import gov.va.genisis2.model.RequestType;
import gov.va.genisis2.model.RoleType;
import gov.va.genisis2.model.Source;
import gov.va.genisis2.model.StudyApproval;
import gov.va.genisis2.model.UserApprover;
import gov.va.genisis2.model.UserRoleType;
import gov.va.genisis2.model.UserType;
import gov.va.genisis2.model.Users;
import gov.va.genisis2.model.WorkflowStatus;

/**
 * @author Getaneh Kassahun
 * 
 * 
 */
public class Helper {

	/**
	 * This method is used to getNewRequest.
	 * 
	 * @return this returns new request.
	 * 
	 */
	public static Request getNewRequest() {
		Request request = new Request();
		request.setId(1);
		request.setTitle("Postman Sample Create Request");
		request.setDescription("This is a sample new request for demo purposes");
		request.setRequestTypeID(1);
		request.setSourceID(1);
		request.setStudyApprovalID(176);
		request.setCreatedBy("genisisresearcher1@gmail.com");
		request.setCreatedOn(new Date());
		request.setModifiedBy("genisisresearcher1@gmail.com");
		request.setModifiedOn(new Date());
		request.setType(1);
		request.setTaskId("taskId");
		request.setProcessId(1);
		request.setApproverId("genisismger1@gmail.com");
		request.setRequestHistories(getNewRequestHistories());
		request.setStatusDescription("StatusDescription");

		return request;
	}

	/**
	 * This method is used to getNewRequest.
	 * 
	 * @return this returns new request.
	 * 
	 */
	public static Request getNewRequest1() {
		return new Request(2, getNewRequestType(), getNewStudyApproval(), getNewSource(), 2);
	}

	/**
	 * This method is used to getNewRequest.
	 * 
	 * @return this returns new request.
	 * 
	 */
	public static Request getNewRequest2() {
		return new Request(3, getNewRequestType(), getNewStudyApproval(), getNewSource(), 2,
				"Postman Sample Create Request", "This is a sample new request for demo purposes", "Submitted",
				new Date(), new Date(), "genisisresearcher1@gmail.com", "genisisresearcher1@gmail.com",
				"genisisresearcher1@gmail.com", "taskId", getNewRequestHistories());
	}

	private static Set<RequestHistory> getNewRequestHistories() {
		Set<RequestHistory> requestHistories = new HashSet<>(Arrays.asList(getNewRequestHistory()));

		return requestHistories;
	}

	public static RequestHistory getNewRequestHistory() {
		RequestHistory requestHistory = new RequestHistory();

		requestHistory.setHistLineNo(1);
		requestHistory.setRequest(new Request());
		requestHistory.setProcessId(1);
		requestHistory.setTitle("Postman Sample Create Request - Updated");
		requestHistory.setDescription("This is a sample new request for demo purposes - updated");
		requestHistory.setStatusDescription("Draft");
		requestHistory.setRequestTypeId(1);
		requestHistory.setSourceId(1);
		requestHistory.setStudyApprovalId(1);
		requestHistory.setCreatedOn(new Date());
		requestHistory.setModifiedOn(new Date());
		requestHistory.setCreatedBy("genisisdatamgr1@gmail.com");
		requestHistory.setModifiedBy("researcher1");
		requestHistory.setApproverId("genisisdatamgr2@gmail.com");
		requestHistory.setTaskId("taskId");

		return requestHistory;
	}
	
	public static RequestHistory getNewRequestHistory1() {
		RequestHistory requestHistory = new RequestHistory(1, new Request(), 1,
				"Postman Sample Create Request - Updated", "This is a sample new request for demo purposes - updated",
				"Draft", 1, 1, 1, new Date(), new Date(), "genisisdatamgr1@gmail.com", "researcher1",
				"genisisdatamgr2@gmail.com", "taskId");

		return requestHistory;
	}

	/**
	 * This method is used to getExistingRequest.
	 * 
	 * @return this returns ExistingRequest.
	 * 
	 */
	public static Request getExistingRequest() {
		Request request = new Request();
		request.setProcessId(999999999);
		request.setId(98);
		request.setTitle("Postman Sample Create Request");
		request.setDescription("This is a sample new request for demo purposes");
		request.setStatusDescription("Return");
		request.setCreatedOn(new Date());
		request.setType(1);
		request.setCreatedBy("researcher1");
		request.setModifiedBy("researcher1");
		request.setApproverId("datamanager1");
		request.setComments("Need more information");
		request.setSource(getNewSource());
		request.setRequestType(getNewRequestType());
		request.setStudyApproval(getStudyApproval());

		return request;
	}

	/**
	 * This method is used to getListOfRequest.
	 * 
	 * @return this returns listOfRequest.
	 * 
	 */
	public static List<Request> getListOfRequest() {
		List<Request> listOfRequest = new ArrayList<>();
		Request request = getExistingRequest();
		Request request2 = getExistingRequest();
		request2.setId(2);
		listOfRequest.add(request);
		listOfRequest.add(request2);

		return listOfRequest;
	}

	/**
	 * Source
	 * 
	 * @return Source
	 */
	public static Source getNewSource() {
		Source source = new Source();
		source.setId(1);
		source.setDescription("Survey");
		source.setRequests(new HashSet<>(Arrays.asList(new Request())));

		return source;
	}

	/**
	 * Source
	 * 
	 * @return Source
	 */
	public static Source getNewSource1() {
		Source source = new Source(2);
		source.setDescription("Survey");

		return source;
	}

	/**
	 * Source
	 * 
	 * @return Source
	 */
	public static Source getNewSource2() {
		return new Source(3, "Survey", new HashSet<>(Arrays.asList(new Request())));
	}

	/**
	 * RequestType
	 * 
	 * @return RequestType
	 */
	public static RequestType getNewRequestType() {
		RequestType requestType = new RequestType();
		requestType.setId(1);
		requestType.setDescription("Aggregate");
		requestType.setRequests(new HashSet<>(Arrays.asList(new Request())));

		return requestType;
	}
	
	/**
	 * RequestType
	 * 
	 * @return RequestType
	 */
	public static RequestType getNewRequestType1() {
		RequestType requestType = new RequestType(2);
		requestType.setDescription("Aggregate");
		requestType.setRequests(new HashSet<>(Arrays.asList(new Request())));

		return requestType;
	}
	
	/**
	 * RequestType
	 * 
	 * @return RequestType
	 */
	public static RequestType getNewRequestType2() {
		RequestType requestType = new RequestType(3, "Aggregate", new HashSet<>(Arrays.asList(new Request())));

		return requestType;
	}

	/**
	 * StudyApproval
	 * 
	 * @return StudyApproval
	 */
	public static StudyApproval getNewStudyApproval() {
		StudyApproval studyApproval = new StudyApproval(1);
		List<Integer> associatedApprovals = new ArrayList<Integer>();

		associatedApprovals.add(1);
		associatedApprovals.add(2);
		associatedApprovals.add(3);
		studyApproval.setAssociatedApprovals(associatedApprovals);
		studyApproval.setTitle("Postman sample study approval");
		studyApproval.setDescription("this is a study approval for demo purposes");
		studyApproval.setCreatedBy("researcher1");
		studyApproval.setModifiedOn(new Date());
		studyApproval.setApprovalIdObtained("approvalIdObtained");
		studyApproval.setModifiedBy("datamanager1");
		studyApproval.setCreatedBy("researcher1");
		studyApproval.setRequests(new HashSet<>(Arrays.asList(new Request())));

		return studyApproval;
	}

	/**
	 * StudyApproval
	 * 
	 * @return StudyApproval
	 * 
	 */
	public static StudyApproval getNewStudyApproval1() {
		StudyApproval studyApproval = new StudyApproval(2, 2);
		List<Integer> associatedApprovals = new ArrayList<Integer>();

		associatedApprovals.add(1);
		associatedApprovals.add(2);
		associatedApprovals.add(3);
		studyApproval.setAssociatedApprovals(associatedApprovals);
		studyApproval.setTitle("Postman sample study approval");
		studyApproval.setDescription("this is a study approval for demo purposes");
		studyApproval.setCreatedBy("researcher1");
		studyApproval.setCreatedOn(new Date());
		studyApproval.setModifiedOn(new Date());
		studyApproval.setApprovalIdObtained("approvalIdObtained");
		studyApproval.setModifiedBy("datamanager1");
		studyApproval.setCreatedBy("researcher1");
		studyApproval.setRequests(new HashSet<>(Arrays.asList(new Request())));

		return studyApproval;
	}

	/**
	 * StudyApproval
	 * 
	 * @return StudyApproval
	 * 
	 */
	public static StudyApproval getNewStudyApproval2() {
		return new StudyApproval("approvalIdObtained", 3, 3, "Postman sample study approval",
				"this is a study approval for demo purposes", new Date(), new Date(), "researcher1", "datamanager1", 1,
				2, 3, new HashSet<>(Arrays.asList(new Request())));
	}

	/**
	 * StudyApproval
	 * 
	 * @return StudyApproval
	 * 
	 */
	public static StudyApproval getStudyApproval() {
		StudyApproval studyApproval = new StudyApproval();
		studyApproval.setId(1);
		studyApproval.setProcessId(0);
		studyApproval.setTitle("csp572");
		studyApproval.setDescription("csp572");
		studyApproval.setCreatedOn(new Date());
		studyApproval.setModifiedOn(new Date());
		studyApproval.setProcessId(999999999);
		studyApproval.setApprovalIdObtained("approvalIdObtained");
		studyApproval.setModifiedBy("datamanager1");
		studyApproval.setCreatedBy("researcher1");

		return studyApproval;
	}

	/**
	 * Users
	 * 
	 * @return Users
	 */
	public static Users getUsers() {
		Users users = new Users();
		users.setFirstName("Getaneh");
		users.setLastName("Kassa");
		users.setCreateDate(new Date());
		users.setEmailId("genisisad@gmail.com");
		users.setUserActive((byte) 1);
		users.setActiveDate(new Date());
		users.setInactiveDate(null);
		users.setApprover("datamanager1");

		return users;
	}

	/**
	 * Users
	 * 
	 * @return Users
	 */
	public static Users getNewUser() {
		Users users = new Users();
		users.setUserId(1);
		users.setFirstName("fNmae");
		users.setMiddleName("mName");
		users.setLastName("lName");
		users.setLastName2("lName2");
		users.setCreateDate(new Date());
		users.setEmailId("genisisdatamgr1@gmail.com");
		users.setUserActive((byte) 1);
		users.setActiveDate(new Date());
		users.setInactiveDate(new Date());
		users.setUserApproversForUserId(new HashSet<>(Arrays.asList(new UserApprover())));
		users.setUserRoleTypes(new HashSet<>(Arrays.asList(new UserRoleType())));
		users.setUserApproversForUserApproverId(new HashSet<>(Arrays.asList(new UserApprover())));
		users.setRole("role");
		users.setApprover("datamanager1");

		return users;
	}

	/**
	 * Users
	 * 
	 * @return Users
	 */
	public static Users getNewUser1(){
		Users users = new Users(2,"firstName", "lastName", new Date(), "genisisdatamgr1@gmail.com", (byte) 1,
				new Date());
		users.setMiddleName("mName");
		users.setLastName2("lName2");
		users.setInactiveDate(new Date());
		users.setUserApproversForUserId(new HashSet<>(Arrays.asList(new UserApprover())));
		users.setUserRoleTypes(new HashSet<>(Arrays.asList(new UserRoleType())));
		users.setUserApproversForUserApproverId(new HashSet<>(Arrays.asList(new UserApprover())));
		users.setRole("role");
		users.setApprover("datamanager1");
		
		return users;
	}
	
	/**
	 * Users
	 * 
	 * @return Users
	 */
	public static Users getNewUser2() {
		Users users = new Users(3, "firstName", "middleName", "lastName", "lastName2", new Date(),
				"genisisdatamgr1@gmail.com", (byte) 1, new Date(), new Date(),
				new HashSet<>(Arrays.asList(new UserApprover())), new HashSet<>(Arrays.asList(new UserRoleType())),
				new HashSet<>(Arrays.asList(new UserApprover())));

		users.setRole("role");
		users.setApprover("datamanager1");

		return users;
	}

	/**
	 * StudyApproval
	 * 
	 * @return StudyApproval
	 * 
	 */
	public static List<StudyApproval> getListOfStudyApproval() {
		List<StudyApproval> listOfStudyApproval = new ArrayList<StudyApproval>();

		StudyApproval studyApproval1 = new StudyApproval();
		studyApproval1.setId(1);
		studyApproval1.setProcessId(0);
		studyApproval1.setTitle("csp572");
		studyApproval1.setDescription("csp572");
		studyApproval1.setCreatedOn(new Date());
		studyApproval1.setModifiedOn(new Date());
		studyApproval1.setProcessId(999999999);
		studyApproval1.setApprovalIdObtained("approvalIdObtained");
		studyApproval1.setModifiedBy("datamanager1");
		studyApproval1.setCreatedBy("researcher1");

		StudyApproval studyApproval2 = new StudyApproval();
		studyApproval2.setId(2);
		studyApproval2.setProcessId(0);
		studyApproval2.setTitle("csp572");
		studyApproval2.setDescription("csp572");
		studyApproval2.setCreatedOn(new Date());
		studyApproval2.setModifiedOn(new Date());
		studyApproval2.setProcessId(999999999);
		studyApproval2.setApprovalIdObtained("approvalIdObtained");
		studyApproval2.setModifiedBy("datamanager1");
		studyApproval2.setCreatedBy("researcher1");

		listOfStudyApproval.add(studyApproval1);
		listOfStudyApproval.add(studyApproval2);

		return listOfStudyApproval;
	}

	/**
	 * WorkflowStatus
	 * 
	 * @param status
	 * @return WorkflowStatus
	 * 
	 */
	public static WorkflowStatus getWorkFlowStatus(String status) {
		WorkflowStatus workflowStatus = new WorkflowStatus();

		switch (status) {
		case "Draft":
			workflowStatus.setId(1);
			workflowStatus.setDescription("Draft");
			break;
		case "Submitted":
			workflowStatus.setId(2);
			workflowStatus.setDescription("Submitted");
			break;
		case "Denied":
			workflowStatus.setId(3);
			workflowStatus.setDescription("Denied");
			break;
		case "Returned":
			workflowStatus.setId(4);
			workflowStatus.setDescription("Returned");
			workflowStatus.setCommentHistories(new HashSet<>(Arrays.asList(new CommentHistory())));
			break;
		case "Sent":
			workflowStatus.setId(5);
			workflowStatus.setDescription("Sent");
			break;
		case "Update":
			workflowStatus.setId(6);
			workflowStatus.setDescription("Update");
		case "RequestAccepted":
			workflowStatus.setId(7);
			workflowStatus.setDescription("RequestAccepted");
			break;
		case "RequestNotAccepted":
			workflowStatus.setId(8);
			workflowStatus.setDescription("RequestNotAccepted");
			break;
		case "ResultsAccepted":
			workflowStatus.setId(9);
			workflowStatus.setDescription("ResultsAccepted");
			break;
		case "ResultsNotAccepted":
			workflowStatus.setId(10);
			workflowStatus.setDescription("ResultsNotAccepted");
			break;
		case "ResultsDelivered":
			workflowStatus.setId(11);
			workflowStatus.setDescription("ResultsDelivered");
			break;
		default:
			throw new IllegalArgumentException("Invalid Status: " + status);
		}

		return workflowStatus;
	}

	/**
	 * CommentHistory
	 * 
	 * @return CommentHistory
	 */
	public static CommentHistory getCommentHistory() {
		CommentHistory commentHistory = new CommentHistory();
		commentHistory.setCommentId(1);
		commentHistory.setRequest(getExistingRequest());
		commentHistory.setWorkflowStatus(getWorkFlowStatus("Returned"));
		commentHistory.setComments("Returned request");
		commentHistory.setCreatedOn(new Date());
		commentHistory.setCreatedBy("datamanger1");
		commentHistory.setRequestId(1);
		commentHistory.setStatus("status");
		commentHistory.setType("type");
		commentHistory.setTaskId("taskId");

		return commentHistory;
	}

	/**
	 * CommentHistory
	 * 
	 * @return CommentHistory
	 */
	public static CommentHistory getCommentHistory1() {
		CommentHistory commentHistory = new CommentHistory(1, getExistingRequest(), getWorkFlowStatus("Returned"), "Returned request",
				new Date(), "datamanger1", "taskId");
		commentHistory.setWorkflowStatus(new WorkflowStatus(1));
		
		return commentHistory;
	}

	/**
	 * CommentHistory
	 * 
	 * @return CommentHistory
	 */
	public static CommentHistory getCommentHistory2() {
		return new CommentHistory(1, getExistingRequest(), getWorkFlowStatus("Returned"));
	}

	/**
	 * CommentHistory
	 * 
	 * @return list of CommentHistory
	 */
	public static List<CommentHistory> getListOfCommentHistory() {
		List<CommentHistory> listOfCommentHistory = new ArrayList<CommentHistory>();
		CommentHistory commentHistory1 = new CommentHistory(1, getExistingRequest(), getWorkFlowStatus("Returned"),
				"Returned request", new Date(), "datamanger1", "taskId");
		CommentHistory commentHistory2 = new CommentHistory(2, getExistingRequest(), getWorkFlowStatus("Returned"),
				"Returned request", new Date(), "datamanger1", "taskId");

		listOfCommentHistory.add(commentHistory1);
		listOfCommentHistory.add(commentHistory2);

		return listOfCommentHistory;
	}

	/**
	 * Create test object for UserType
	 * 
	 * @return UserType
	 */
	public static UserType getNewUserType() {
		UserType userType = new UserType();
		userType.setUserTypeId(1);
		userType.setUserTypeDesc("Employee");
		userType.setUserRoleTypes(null);

		return userType;
	}

	/**
	 * Create test object for UserType
	 * 
	 * @return UserType
	 */
	public static UserType getNewUserType1() {
		return new UserType(2, "Employee");
	}

	/**
	 * Create test object for UserType
	 * 
	 * @return UserType
	 */
	public static UserType getNewUserType2() {
		return new UserType(2, "Employee", null);
	}

	/**
	 * Create test object for RoleType
	 * 
	 * @return RoleType
	 */
	public static RoleType getNewRoleType() {
		RoleType roleType = new RoleType();
		roleType.setRoleTypeId(1);
		roleType.setRoleName("Administrator");
		roleType.setRoleDescription("Administrator");
		roleType.setUserRoleTypes(null);

		return roleType;
	}

	/**
	 * Create test object for RoleType
	 * 
	 * @return RoleType
	 */
	public static RoleType getNewRoleType1() {
		return new RoleType(2, "Administrator", "Administrator");
	}

	/**
	 * Create test object for RoleType
	 * 
	 * @return RoleType
	 */
	public static RoleType getNewRoleType2() {
		return new RoleType(3, "Administrator", "Administrator", null);
	}

	/**
	 * Create test object for UserRoleType
	 * 
	 * @return UserRoleType
	 */
	public static UserRoleType getNewUserRoleType() {
		UserRoleType userRoleType = new UserRoleType();
		userRoleType.setId(1);
		userRoleType.setRoleType(getNewRoleType());
		userRoleType.setUsers(getUsers());
		userRoleType.setUserType(getNewUserType());
		Calendar startDate = Calendar.getInstance();
		startDate.set(2017, 5, 24);
		userRoleType.setStartDate(startDate.getTime());
		userRoleType.setEndDate(startDate.getTime());

		return userRoleType;
	}

	/**
	 * Create test object for UserRoleType
	 * 
	 * @return UserRoleType
	 */
	public static UserRoleType getNewUserRoleType1() {
		Calendar startDate = Calendar.getInstance();
		startDate.set(2017, 5, 24);

		UserRoleType userRoleType = new UserRoleType(2, getNewRoleType(), getUsers(), getNewUserType(),
				startDate.getTime());
		return userRoleType;
	}

	/**
	 * Create test object for UserRoleType
	 * 
	 * @return UserRoleType
	 */
	public static UserRoleType getNewUserRoleType2() {
		Calendar startDate = Calendar.getInstance();
		startDate.set(2017, 5, 24);

		UserRoleType userRoleType = new UserRoleType(3, getNewRoleType(), getUsers(), getNewUserType(),
				startDate.getTime(), startDate.getTime());
		return userRoleType;
	}
	
	/**
	 * Create test object for UserApprover
	 * 
	 * @return UserApprover
	 */
	public static UserApprover getNewUserApprover() {
		UserApprover userApprover = new UserApprover();
		userApprover.setId(1);
		userApprover.setUsersByUserApproverId(getNewUser());
		userApprover.setUsersByUserId(getNewUser());
		
		return userApprover;
	}
	
	/**
	 * Create test object for UserApprover
	 * 
	 * @return UserApprover
	 */
	public static UserApprover getNewUserApprover1() {
		UserApprover userApprover = new UserApprover(2, getNewUser(), getNewUser());
		
		return userApprover;
	}
}
